<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\ClassRoom;
use Illuminate\Http\Request;
use App\Models\StudentSubscribe;
use App\Jobs\MailNotificationQueue;
use Maatwebsite\Excel\Concerns\ToArray;
use App\Http\Requests\StoreStudentSubscribeRequest;
use App\Http\Requests\UpdateStudentSubscribeRequest;

class StudentSubscribeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($classRoomId)
    {
        $classRoom = ClassRoom::find($classRoomId);
        $subscribes = StudentSubscribe::with('student')->where('room_id', $classRoomId)->get();
        if(count($subscribes)<1)
            return redirect()->route('subscribers_crete',$classRoom->id);
        return view('subscribes.list')->with([
            'classRoom' => $classRoom,
            'subscribes' => $subscribes,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($classRoomId)
    {
        // return  $users = User::all()->except([1]);
        $classRoom = ClassRoom::find($classRoomId);
        $subscribes = StudentSubscribe::with('student')->where('room_id', $classRoomId)->get()->map(function ($item) {
            return $item->student->id;
        })->toArray();
        $students = User::student()->active()->resetPass()->get()->except($subscribes);
        return view('subscribes.modals.create')->with([
            'classRoom' => $classRoom,
            'students' => $students,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreStudentSubscribeRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreStudentSubscribeRequest $request)
    {
        try {
            
            $room = ClassRoom::with('course')->find($request->classRoomId);
            if($request->subscribes==null)
                return back()->with(['error'=>'يرجى إضافة متدرب واحد على الأقل']);
            foreach ($request->subscribes as $subscribe) {
                $newSubscribe = new StudentSubscribe();
                $newSubscribe->room_id = $request->classRoomId;
                $newSubscribe->student_id = $subscribe;
                $newSubscribe->degree = 0.0;
                $student = User::find($newSubscribe->student_id);
                $studentName=$student->name;
                $roomName = $room->name;
                 $courseName= $room->course->title;
                $newSubscribe->save();
             $content = 'مرحبا ' . $studentName . ' لقد تم إضافتك كمتدرب في    ' . $roomName.' برنامج '.$courseName;
             $route = 'user_dash';
             $email = $student->name;//change to $student->email;
             $subjectEmail = '  اشتراك في برنامج ';
          
             NotificationController::sendNotificationFromAdmin($student->id, $content, $route, 3);
            try {
                MailNotificationQueue::dispatch($content,$route,$email,$subjectEmail);
            } catch (\Throwable$th) {
                return back()->with(['warning' => 'لم يتم إسال الإيميلات']);
            } 
            }
            return redirect()->route('students_subscribers', $request->classRoomId)->with(['success' => 'تم إضافة اشتراكات الطلاب بنجاح']);
        } catch (\Throwable $th) {
            return back()->with(['error' => 'لم يتم إضافة اشتراكات الطلاب  ']);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\StudentSubscribe  $studentSubscribe
     * @return \Illuminate\Http\Response
     */
    public function show(studentSubscribe $studentSubscribe)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\StudentSubscribe  $studentSubscribe
     * @return \Illuminate\Http\Response
     */
    public function edit(StudentSubscribe $studentSubscribe)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateStudentSubscribeRequest  $request
     * @param  \App\Models\StudentSubscribe  $studentSubscribe
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateStudentSubscribeRequest $request, StudentSubscribe $studentSubscribe)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\StudentSubscribe  $studentSubscribe
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request)
    {
        try {
            StudentSubscribe::find($request->id)->delete();
            return back()->with(['success' => 'تم حذف الدرس بنجاح']);
        } catch (\Throwable $th) {
            return back()->with(['error' => 'لم يتم حذف الدرس ']);
        }
    }
}
